local function add_structure(f)
	if(f) then
		f.shape_table_data = 
		{
			{
				file  	    = f.ShapeName,
				life	    = f.Life,
				username    = f.Name,
				desrt       = f.ShapeNameDestr or "self",
			        classname   = f.classname   or "lLandVehicle",
				positioning = f.positioning or "ONLYHEIGTH"	--available: {"BYNORMAL", "ONLYHEIGTH", "BY_XZ", "ADD_HEIGTH"}
			}
		}
		if f.ShapeNameDestr then
			f.shape_table_data[#f.shape_table_data + 1] = 
			{
				name  = f.ShapeName,
				file  = f.ShapeNameDestr,	
			}
		end
		
		
		--f.mapclasskey = "P0091000022";
		if f.keynum then
			f.mapclasskey = f.keynum
		else
			f.mapclasskey = "P0091000076"
		end

		f.attribute = {wsType_Static, wsType_Standing} -- if 'attribute' == nil then insertion will be aborted

		if f.conf_fire then
			f.visual = f.conf_fire
		end

		if f.conf_animation then
			f.animation_arguments = f.conf_animation
		end
		
		add_surface_unit(f)
		GT = nil;
	else
		error("Can't add Riza24 structure(Spacer.lua)")
	end;
end

--****************************************************************
-- Riz24_PrivateSmallBase
--
-- Spacerで高さ調整できるようにする
--
add_structure({
	Name 		 	=	"R24G Spacer50",
	DisplayName  	=	_("R24G Spacer50"),
	ShapeName	 	=	"Riz24_Spacer50",
	desrt		 	=	"Riz24_Spacer50",
	Life		 	=	1000,
	Rate		 	=	10,
	SeaObject	 	=	true,
	isPutToWater 	=	true,
	positioning  	=	"ONLYHEIGTH",
	--category     	=	'Fortification',
	--classname    	=	"lStandartStructure",
	category     =  'Heliport',
	classname    =  "lHeliport",
})


add_structure({
	Name 		 	=	"R24G Spacer10",
	DisplayName  	=	_("R24G Spacer10"),
	ShapeName	 	=	"Riz24_Spacer10",
	desrt		 	=	"Riz24_Spacer10",
	Life		 	=	1000,
	Rate		 	=	10,
	SeaObject	 	=	true,
	isPutToWater 	=	true,
	positioning  	=	"ONLYHEIGTH",
	--category     	=	'Fortification',
	--classname    	=	"lStandartStructure",
	category     =  'Heliport',
	classname    =  "lHeliport",
})

add_structure({
	Name 		 	=	"R24G Leveler",
	DisplayName  	=	_("R24G Leveler"),
	ShapeName	 	=	"Riz24_Leveler",
	desrt		 	=	"Riz24_Leveler",
	Life		 	=	1000,
	Rate		 	=	10,
	SeaObject	 	=	true,
	isPutToWater 	=	true,
	positioning  	=	"ONLYHEIGTH",
	--category     	=	'Fortification',
	--classname    	=	"lStandartStructure",
	category     =  'Heliport',
	classname    =  "lHeliport",
})

